(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2329,         72]*)
(*NotebookOutlinePosition[      2975,         94]*)
(*  CellTagsIndexPosition[      2931,         90]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(calculoden[a_, b_, #] := 
      Module[{i = 1, termino = #[a, 1], val = {1}}, 
        While[termino \[GreaterEqual] b, termino = #[a, i + 1]; 
          AppendTo[val, i + 1]; \(i++\)]; Last[val]]\)], "Input"],

Cell[BoxData[
    \(f[x_, n_] := \(x\^n\) \((1 - x\^n)\)\)], "Input"],

Cell[BoxData[
    \(g[x_, n_] := 
      Abs[N[Exp[x] - 1 - \[Sum]\_\(k = 1\)\%n x\^k/\(k!\)]]\)], "Input"],

Cell[BoxData[
    \(Map[calculoden[0.99, 10^\(-4\), #] &, {f, g}]\)], "Input"],

Cell[BoxData[
    \(x[n_] := Nest[\@\(1 + #\) &, 1, n]\)], "Input"],

Cell[BoxData[
    \(Table[N[x[k]], {k, 15}]\)], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 680}},
WindowSize->{913, 578},
WindowMargins->{{32, Automatic}, {-26, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 229, 4, 50, "Input"],
Cell[1937, 56, 69, 1, 30, "Input"],
Cell[2009, 59, 106, 2, 33, "Input"],
Cell[2118, 63, 78, 1, 30, "Input"],
Cell[2199, 66, 67, 1, 33, "Input"],
Cell[2269, 69, 56, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

